<?php
require_once('view_config.php');

# **************************************
# js キャッシュ用
# **************************************
$tm = time();

# **************************************
# 画面定義
# ( Ruby や Python に合わせた画面形式 )
# **************************************
$out_client = <<<HTML
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta content="width=device-width initial-scale=1.0 minimum-scale=1.0 maximum-scale=1.0 user-scalable=no" name="viewport">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.3.1/css/bootstrap.min.css" />

<script src="{$view_js}?{$tm}"></script>

<style>
/* ブロックを左右に表示  */
.ttl {
	display: inline-block;
	width: 150px;
}
.entry {
	display: inline-block;
}
.line {
	margin-bottom: 0;
}


/* IFRAMEコントロール用  */
html,body {
	height: 100%;
}

body {
	margin: 0;
}

/* IFRAMEコントロール用  */
#head {
	padding: 16px;
	width: 100%;
	background-color: #e0e0e0;
}
#extend {
	display: block;
	margin-left: auto;
	margin-right: auto;
	width: calc( 100% - 4px );
	/* border: solid 2px #c0c0c0; */
	border: 0px;
}

@media screen and ( min-width:480px ) {
	#head {
		height: {$view_head_height}px;
	}
	#extend {
		height: calc( 100% - {$view_head_height}px - 2px );
	}
}

@media screen and ( max-width:479px ) {

	#head {
		height: {$view_head_height_mobile}px;
	}
	#extend {
		height: calc( 100% - {$view_head_height_mobile}px - 2px );
	}

}



</style>
</head>
<body>

<div id="head">
	<p class="ttl">
		氏名で検索
	</p>
	<p class="entry">
		<input
			id="cond"
			type="text"
			class="mr-4 mb-3">
		<input
			class="mr-4 btn btn-success"
			id="btn"
			type="button"
			value="問合せ">

		<a
			class="ml-4 btn btn-info btn-sm"
			href="{$_SERVER["PHP_SELF"]}">GET 再読み込み</a>
	</p>
	<p class="line"></p>

	<h4 class="text-danger">{$check_message}</h4>

</div>

<iframe id="extend" name="extend" src="req/control.php"></iframe>

</body>
</html>
HTML;

print $out_client;


?>
