<?php
error_reporting( E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED );
session_cache_limiter('nocache');
session_start();

header( "Content-Type: text/html; charset=utf-8" );


// **************************
// 初期画面( URL 呼び出し )
// **************************
if ( $_SERVER["REQUEST_METHOD"] == "GET" ) {


}

// **************************
// 更新処理
// **************************
if ( $_SERVER["REQUEST_METHOD"] == "POST" ) {

	$obj = new stdClass;
	$obj->user = $_POST['user'];
	$obj->name = $_POST['name'];

	$stream = stream_context_create(
		array(
			'http' => array(
				'method'=> 'PUT',
				'header'=> 'Content-type: application/json; charset=utf-8',
				'content' => json_encode( $obj )
			)
		)
	);

	// 事前に user 階層のみ作成しておく
	$url = "https://r101-78dc5.firebaseio.com/user/{$_POST['user']}.json";
	$file = @file_get_contents($url, false, $stream);
	if ( $file === false ) {
		$GLOBALS['error'] = $http_response_header[0];
	}

}


// **************************
// 画面定義
// **************************
?>
<!DOCTYPE html>
<html>
<head>
<meta content="width=device-width initial-scale=1.0 minimum-scale=1.0 maximum-scale=1.0 user-scalable=no" name="viewport">
<meta charset="utf-8">

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.3.1/css/bootstrap.css">

<style>
/* ****************************
 上下エリア
 フィットコントロール用
******************************/
html,body {
	height: 100%;
}
/* ****************************
 それぞれのエリアの特性
******************************/
/* 基本枠 */
body {
	margin: 0;
}
/* 上固定部分 */
#page {
	display: block;
	margin: auto;
	width: 100%;
	height: 100%;
	background-color: #e0e0e0;
}

* {
	font-size: 16px;
	font-family: "ヒラギノ角ゴPro W6","Hiragino Kaku Gothic Pro W6","メイリオ",Meiryo,"ＭＳ Ｐゴシック",Verdana,Arial,Helvetica,sans-serif;
}
#head {
	background-color: #404040;
	padding: 10px 15px 10px 15px;
}
#head * {
	color: #ffffff;
}

/* PC 用の表示 */
@media screen and ( min-width:480px ) {
	#content {
		margin: 20px;
	}
	#base {
		width: 650px;
		border: 0px solid #ff0000;
	}
	.left,.right {
		height: 50px;
	}	
	
	.left {
		display:inline-block;
		width: 100px;
		vertical-align: baseline;
		padding-top: 0.5rem;	
	}
	.right {
		display:inline-block;
		padding-bottom: 40px;
	}

}

/* スマホ用の表示 */
@media screen and ( max-width:479px ) {
	#content {
		margin: 0px;
	}
	#base {
		margin-top: 8px;
	}
	.unit {
		width: 100%;
	}
	
	.left,.right {
	}

	.left {
		padding: 4px;
	}

	#btn {
		margin-top: 10px;
	}
}

</style>

<script>
// ******************************
// jQuery onload イベント
// ******************************
$(function(){


});

// ******************************
// 確認ボタンの時の送信チェック
// ******************************
function check(){

	if ( !confirm("更新してもよろしいですか?") ) {
		return false;
	}

	return true;
}
</script>
</head>

<body>
<div id="page">
	<div id="head">
		<div id="title">
			<a href="index.html">ユーザ登録</a>
		</div>
	</div>

	<div id="content">

		<form id="base" method="post"
			onsubmit="return check()">

			<div class="body">
				<div class="left">ユーザID</div>

				<div class="right">
					<input
						maxlength="50"
						required
						type="text" 
						name="user" 
						id="user" 
						class="unit">
				</div>
			</div>
			<div class="body">
				<div class="entry left">ユーザ名</div>

				<div class="entry right">
					<input 
						maxlength="50"
						required
						type="text" 
						name="name"
						id="name" 
						class="unit">
				</div>
			</div>


			<div>
				<input
					type="submit"
					name="btn"
					id="btn"
					value="更新"
					class="btn btn-primary unit">

				<span class="ml-5"><?= $error_string ?></span>
			</div>

		</form>
	</div>
</div>

</body>
</html>
