<?php
// ***********************************************
// PHP としての共通部分
// ***********************************************
// 不必要なエラー表示を行わない
error_reporting( E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED );

// ブラウザのキャッシュに保存しない
session_cache_limiter('nocache');
// セッションの開始
session_start();

// この ページの MIME( ページの種類 ) の設定
header( "Content-Type: text/html; charset=utf-8" );
// ***********************************************


$image_path = "./myimages";

?>
<!DOCTYPE html>
<html>
<head>
<meta content="width=device-width initial-scale=1.0 minimum-scale=1.0 maximum-scale=1.0 user-scalable=no" name="viewport">
<meta charset="UTF-8">
<title>単純ファイルアップロード + 画像表示で確認</title>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.4.0/css/bootstrap.css">
<style>
* {
	font-family: Arial, Helvetica, Verdana, "ヒラギノ角ゴPro W3", "Hiragino Kaku Gothic Pro", Osaka, "メイリオ", Meiryo, "ＭＳ Ｐゴシック", sans-serif!important;
}

#images {
	padding: 10px;
}

#images img {
	width: 100px;
	margin: 6px;
}

#head {
	background-color: #404040;
	padding: 10px 15px 10px 15px;
}
#head * {
	color: #ffffff;
}

/* PC 用の表示 */
@media screen and ( min-width:480px ) {
	#content {
		margin: 20px;
	}

}

/* スマホ用の表示 */
@media screen and ( max-width:479px ) {
	#content {
		margin: 0px;
	}
}

</style>

<script>
$(function(){
	// INPUT type="file" のファイル選択後のイベント
	$("#target").on("change", function(){

		// 画像表示部分をクリア
		$("#image").html("");

		// 選択されたファイルの情報
		console.dir( this.files );

		// ファイル参照用のクラス : FileReader
		var reader = new FileReader();

		// 表示用にプロパティを追加
		reader.name = this.files[0].name;
		reader.type = this.files[0].type;

		// 画像が読み込まれると実行されるイベント
		$(reader).on("load", function () {

			// FileReader の内容
			console.dir( this );

			if ( this.type.indexOf("image/") == 0 ) {
				$("<img>").appendTo("#image")
					.prop( {"src": this.result, "title": this.name + " : " + this.type } )
					.css( {"width": "160px", "margin": "10px","border": "1px solid #c0c0c0" } );
			}
			else {
				$("<img>").appendTo("#image")
					.prop( {"src": "./notimage.png", "title": this.name + " : " + this.type } )
					.css( {"width": "160px", "margin": "10px","border": "1px solid #c0c0c0" } );
			}

		});

		if (this.files[0]) {
			// 画像を読み込み
			reader.readAsDataURL(this.files[0]);
		}

	});
});
</script>

</head>
<body>
<div id="head">
	<div id="title">
		<a href="index.html">ファイルをアップロード</a>
	</div>
</div>

<div id="content">
	<form
		enctype="multipart/form-data"
		method="POST">
	
		<p>
			<input type="hidden" name="MAX_FILE_SIZE" value="1000000">
			<input id="target" name="target" type="file" class="ml-1 mt-3 btn btn-outline-primary">
		</p>
		<p>
			<input type="submit" name="send" value="アップロード" class="ml-1 btn btn-outline-primary">
			<a
				class="ml-4 btn btn-info btn-sm"
				href="<?= $_SERVER["PHP_SELF"] ?>">リロード</a>
		</p>

		<div id="image"></div>
	 
	</form>
</div>
<div id="result">
<?php
// ***********************************************
// リンクで呼ばれたページは GET で呼ばれるので、
// FORM から POST で呼ばれた時だけ処理を行う為、
// $_SERVER というシステム変数をチェックします
// ***********************************************
if ( $_SERVER['REQUEST_METHOD'] == "POST" ) {
 
	if ( !is_dir( $image_path ) ) {

		mkdir( $image_path );

	}

 
	$upload = realpath($image_path);
	$upload .= ( DIRECTORY_SEPARATOR . $_FILES['target']['name'] );

	// *******************************************************
	// アップロードされると、一旦一時ファイルとしてサーバに
	// 置かれるので、move_uploaded_file でアップロードされた
	// 一時ファイルが必要な場合に移動処理を行います
	// *******************************************************
	if ( move_uploaded_file($_FILES['target']['tmp_name'], $upload ) ) {
		print "<p>アップロードに成功しました</p>\n";
	}

	// *******************************************************
	// $_FILE の変数にアップロードされたファイルの情報が入って
	// いますが、日本語を使用したファイル名は扱いが面倒なので
	// システムで自動的に作成したファイル名を使って、DB に
	// 登録したほうがいいでしょう
	// *******************************************************
	print "<pre>";
	print_r( $_FILES );
	print "</pre>";
}

?>

</div>

</body>
</html>
